<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class TicketsModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    function message_sent_within_24_hours($user_id, $type = NULL){
    	$date = strtotime("-1 day");
    	$query_str = 'select * from tickets where open_date > '.$date;
    	if (isset($type) && strlen($type) > 0){
    		$query_str .= ' and category_id = \''.$type.'\'';
    	}
    	
    	$query = $this->db->query($query_str);
    	if ($query !== false && $query->num_rows() > 0){
    		return true;
    	}    	
    	
    	return false;
    }
    
    //create a new ticket
    function create_ticket($parent_id, $user_id, $message, $open_date, $close_date, $type){
    	$this->db->query('insert into tickets (parent_id, user_id, message, open_date, close_date, category_id) values ('.$this->db->escape($parent_id).','.$this->db->escape($user_id).','.$this->db->escape($message).','.$this->db->escape($open_date).','.$this->db->escape($close_date).','.$this->db->escape($type).')');
    }
    
    //get response when no filters for first page
    function get_first_responses($size)
    {
    	return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (ORDER BY open_date DESC) as row from tickets) a where row >=1 and row <='.$this->db->escape($size));
    }
    
    //get # of tickets
    function get_size()
    {
    	return $this->db->query('select COUNT(*) as count from tickets');
    }
    
    //get size after filter
    function get_filtered_size($sql)
    {
    	return $this->db->query('select COUNT(*) as count from tickets where '.$sql);
    }
    
    //get tickets with filters
    function get_tickets_filter($sql,$order,$start,$size)
    {
    	return $this->db->query('select * from (select *, ROW_NUMBER() over (order by '.$order.') as row FROM tickets where '.$sql.') a where row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
    }
    
	function get_tickets_filter_user_order($sql,$order,$start,$size)//get respose with filters
	{
		if ($order == 'user_id DESC'){
			$order = 'DESC';
		}
		else{
			$order = 'ASC';
		}
		return $this->db->query('select * from (select t.*, ROW_NUMBER() over (order by upper(u.username) '.$order.') as row FROM tickets t LEFT OUTER JOIN users u on t.user_id = u.user_id where '.$sql.') a where row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
	}
	
	function get_tickets_filter_category_order($sql,$order,$start,$size)//get respose with filters
	{
		if ($order == 'category_id DESC'){
			$order = 'DESC';
		}
		else{
			$order = 'ASC';
		}
		return $this->db->query('select * from (select t.*, ROW_NUMBER() over (order by upper(tc.category) '.$order.') as row FROM tickets t LEFT OUTER JOIN ticket_category tc on t.category_id = tc.id where '.$sql.') a where row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
	}
    
    //get respose with filters for export
    function get_tickets_filter_export($sql,$order)
    {
    	return $this->db->query('select * FROM tickets where '.$sql.' ORDER BY '.$order);
    }
    
    function get_tickets_filter_export_user_order($sql,$order)//get respose with filters
    {
    	if ($order == 'user_id DESC'){
    		$order = 'DESC';
    	}
    	else{
    		$order = 'ASC';
    	}
    	return $this->db->query('select t.*  from tickets t LEFT OUTER JOIN users u on t.user_id= u.user_id where '.$sql.' order by u.username '.$order);
    }
    
    function get_tickets_filter_export_category_order($sql,$order)//get respose with filters
    {
    	if ($order == 'category_id DESC'){
    		$order = 'DESC';
    	}
    	else{
    		$order = 'ASC';
    	}
    	return $this->db->query('select t.*  from tickets t LEFT OUTER JOIN ticket_category tc on t.category_id= tc.id where '.$sql.' order by tc.category '.$order);
    }
}